//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth 
//Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-02: Air Standard Cycles and their Analysis
//Example: 02.7 Page 
//======================================================

model Ex2_7
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real p1 (unit= "bar")=1; //Inlet pressure
parameter Real p2 (unit= "bar")=32.425;// Pressure at end of isentropic compression
parameter Real r (unit= "")=6; //Ratio of expansion
parameter Real r1 (unit= "")=1.4; // Isentropic index


final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of 
gravity on earth";


// Variable Section
Real rc (unit= "")"Compression ratio";
Real b (unit= "")"Cut off ratio";
Real n (unit= "")"Air standard efficiancy";
Real pm (unit= "bar")"Mean effective pressure";


// Equation Section

equation
rc =( p2/p1) ^(1/ r1);
b=( rc/r) ;
n =(1 -((b^r1 -1) /( rc ^(r1 -1) *r1 *(b -1) ))) *100;
pm =(( p1*rc^r1*n /100* r1 *(b -1)) /(( r1 -1) *(rc -1) ));

end Ex2_7;
