//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth //Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-03: Reactive Systems
//Example: 03.12 Page 
//======================================================

model Ex3_12
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real Ta (unit= "")=150;//Presence of theoritical air 

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";


// Variable Section
Real hfc (unit= "MJ/kmol")"Enthalpy of formation for CO2";
Real hfh (unit= "MJ/kmol")"Enthalpy of formation for water";
Real hfon (unit= "MJ/kmol")"Enthalpy of formation for oxygen";
Real hfch (unit= "MJ/kmol")"Enthalpy of formation for methane";
Real HP (unit= "MJ/kmol")"Total enthalphy on the products side";
Real HR (unit= "MJ/kmol")"Total enthalphy on the reactants side";
Real H (unit= "MJ/kmol")"Total enthalphy change of reactants and products ";
Real np (unit= "moles")"No. of moles of product";
Real nr (unit= "moles")"No. of moles of reactant";
Real n (unit= "moles")"Difference in moles";
Real R (unit= "")"Universal gas constant";
Real t (unit= "K")"Temp";
Real U1 (unit= "MJ/kmol")"Standard internal energy";
Real hfh1 (unit= "MJ/kmol")"Enthalpy of formation for water";
Real HP1 (unit= "MJ/kmol")"Total enthalphy on the products side";
Real H1 (unit= "MJ/kmol")"Change in enthalphy for reactants and products";
Real np1 (unit= "moles")"No. of moles of product";
Real nr1 (unit= "moles")"No. of moles of reactant";
Real n1 (unit= "moles")"Difference in moles";
Real U2 (unit= "MJ/kmol")"Standard internal energy";


// Equation Section

equation
hfc = -393.52; 
hfh = -285.8; 
hfon =0; 
hfch = -74.87; 
HP =( hfc )+(2* hfh ); 
HR =1* hfch ; 
H=HP -HR; 
np =2; 
nr =4; 
n=np -nr; 
R =8.314e-3; 
t =298; 
U1=H -(n*R*t); 
hfh1 = -241.82; 
HP1 =(1* hfc )+(2* hfh1 ); 
H1=HP1 -HR; 
np1 =4; 
nr1 =4; 
n1=np1 - nr1 ; 
U2=H1 -( n1*R*t);

end Ex3_12;
