//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth //Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-03: Reactive Systems
//Example: 03.15 Page 
//======================================================

model Ex3_15
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real T (unit= "K")=600; 
parameter Real p (unit= "atm")=1;
parameter Real R (unit= "J/molK")=8.314;
parameter Real Tr (unit= "K")=298;
parameter Real a (unit= "")=4.503;
parameter Real b (unit= "")=-8.965e-3;
parameter Real c (unit= "")=37.38e-6;
parameter Real d (unit= "")=-36.49e-9;
parameter Real ee (unit= "")=12.22e-12;


final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";

// Variable Section
Real hfc  (unit= "MJ/kmol")"Enthalphy of formation of CO2";
Real hfh (unit= "MJ/kmol")"Enthalphy of formation of water";
Real hfn (unit= "MJ/kmol")"Enthalphy of formation of nitrogen";
Real HP  (unit= "MJ/kmol")"Enthalphy on products side";
Real hch (unit= "MJ/kmol")"Change in enthalphy of methane";
Real hfc1 (unit= "MJ/kmol")"Enthalphy of formation for methane";
Real hfh1 (unit= "MJ/kmol")"Change in enthalphy of water";
Real hfn1 (unit= "MJ/kmol")"Change in enthalphy of nitrogen";
Real HR (unit= "MJ/kmol")"Enthalphy on reactants side";
Real x (unit= "MJ/kmol")"Enthalphy for remaining gases in the product side";
Real hfn2 (unit= "MJ/kmol")"Guess enthalphy for nitrogen gas";
Real Tc (unit= "K")"Corrosponding temp for enthaplhy of guess nitrogen";
Real T1 (unit= "K")"Temp assumed for first trail";
Real hco1 (unit= "MJ/kmol")"Change in enthalphy for the assume temp for CO2";
Real hh1 (unit= "MJ/kmol")"Change in enthalphy for the assume temp for water";
Real hn1 (unit= "MJ/kmol")"Change in enthalphy for the assume temp for nitrogen";
Real HP1 (unit= "MJ/kmol")"Total enthalphy on the products side for first trail";
Real T2 (unit= "K")"Temp assumed for second trail";
Real hco2 (unit= "MJ/kmol")"Change in enthalphy for the assume temp for CO2";
Real hh2 (unit= "MJ/kmol")"Change in enthalphy for the assume temp for water";
Real hn2 (unit= "MJ/kmol")"Change in enthalphy for the assume temp for nitrogen";
Real HP2 (unit= "MJ/kmol")"Total enthalphy on the products side for second trail";
Real T3 (unit= "K")"Temp for third trail";
Real hco3 (unit= "MJ/kmol")"Change in enthalphy for the assume temp for CO2";
Real hh3 (unit= "MJ/kmol")"Change in enthalphy for the assume temp for water";
Real hn3 (unit= "MJ/kmol")"Change in enthalphy for the assume temp for nitrogen";
Real HP3 (unit= "MJ/kmol")"Total enthalphy on the products side for third trail";
Real Ta1 (unit= "K")"Adiabatic temp for constant pressure process";
Real UR1 (unit= "MJ/kmol")"Internal energy of reactants";
Real Tc1 (unit= "K")"Assume temp for first trail";
Real hcoa1 (unit= "MJ/kmol")"Change in enthalphy for the assume temp for CO2";
Real hha1 (unit= "MJ/kmol")"Change in enthalphy for the assume temp for water";
Real hna1 (unit= "MJ/kmol")"Change in enthalphy for the assume temp for nitrogen";
Real UP1 (unit= "MJ/kmol")"Internal energy of products";
Real Tc2 (unit= "K")"Assume temp for second trail";
Real hcoa2 (unit= "MJ/kmol")"Change in enthalphy for the assume temp for CO2";
Real hha2 (unit= "MJ/kmol")"Change in enthalphy for the assume temp for water";
Real hna2 (unit= "MJ/kmol")"Change in enthalphy for the assume temp for nitrogen";
Real UP2 (unit= "MJ/kmol")"Internal energy of products";
Real Tu (unit= "K")"Adiabatic flame temperature at constant pressure process";

// Equation Section

equation
hfc = -393.52; 
hfh = -241.82; 
hfn =0; 
HP =(1* hfc )+(2* hfh )+(7.52* hfn ); //
hch =(R*((a*(T-Tr))+((b /2) *(T^2- Tr ^2) ) +((c /3) *(T^3- Tr^3) ) +(( d/4) *(T^4- Tr ^4)) +(( ee/5) *(T^5-Tr ^5))))/1000; 
hfc1 = -74.87; 
hfh1 =9.247;
hfn1 =8.891;
HR =(( hfc1 + hch ) +(2* hfh1 ) +(7.52* hfn1 )); 
x=HR -HP; 
hfn2 =x /7.52; 
Tc =3700; 
T1 =2800; 
hco1 =140.444;
hh1 =115.294; 
hn1 =85.345; 
HP1 = hco1 +(2* hh1 ) +(7.52* hn1 )+(HR -x); 
T2 =2500; 
hco2 =121.926; 
hh2 =98.964; 
hn2 =74.312; 
HP2 = hco2 +(2* hh2 ) +(7.52* hn2 )+(HR -x); 
T3 =2600; 
hco3 =128.085; 
hh3 =104.37; 
hn3 =77.973; 
HP3 = hco3 +(2* hh3 ) +(7.52* hn3 )+(HR -x); 
Ta1 =((( HR - HP2 )/( HP3 - HP2 ) )*( T3 -T2))+ T2; 
UR1 =HR -(0.01052* R * T); 
Tc1 =3000; 
hcoa1 =146.645; 
hha1 =120.813; 
hna1 =89.036; 
UP1 = hcoa1 +(2* hha1 ) +(7.52* hna1 )+(HR -x) -(0.08746* Tc1 );
Tc2 =3200; 
hcoa2 =165.331; 
hha2 =137.553; 
hna2 =100.161; 
UP2 = hcoa2 +(2* hha2 ) +(7.52* hna2 )+(HR -x) -(0.08746* Tc2 );
Tu =((( UR1 - UP1 )/( UP2 - UP1 ))*( Tc2 - Tc1 ))+ Tc1 ; 

end Ex3_15;
