//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth //Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-03: Reactive Systems
//Example: 03.19 Page 
//======================================================

model Ex3_19
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real p (unit= "atm")=1; 
parameter Real T (unit= "K")=300;
parameter Real Tc (unit= "K")=2400;
parameter Real KP1 (unit= "")=3.866;

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";


// Variable Section
Real K1 (unit= "")"Value of equilibrium constant at 2400K";
Real nr (unit= "moles")"No. of moles of reactants";
Real Pp (unit= "atm/mole")"Pressure exerted on the products side per mole";
Real a (unit= "")"Dissociation of 1 mole of CO2";
Real np  (unit= "moles")"No. of moles of products";
Real xco (unit= "")"Mole fraction of CO2";
Real xc (unit= "")"Mole fraction of CO";
Real xo (unit= "")"Mole fraction of O2";
Real PP (unit= "bar")"Pressure of product";

// Equation Section

equation

K1=e^KP1;
nr =1+0.5; 
Pp =(p*Tc)/( nr*T); 
a =0.098; 
np =(a +2) /2; 
xco =(2*(1 - a) )/(2+ a); 
xc =(2* a )/(2+ a); 
xo=a /(2+ a); 
PP =5.333* np; 

end Ex3_19;
