//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth //Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-03: Reactive Systems
//Example: 03.6 Page 
//======================================================

model Ex3_6
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real t (unit= "deg C")=25; //Temperature of both reactants and products
parameter Real p (unit= "bar")=1; // Pressure of both reactants and products 
parameter Real h (unit= "MJ/kmol")=0; // Enthaphy of all elements at given temp and pressure
parameter Real hf1 (unit= "MJ/kmol")=-103.85; // Enthalpy of compound C3H8 in the reactants side at given temp and pressure
parameter Real hf2 (unit= "MJ/kmol")=-393.52; //Enthalhy of carbondioxide for the given temp and pressure
parameter Real hf3 (unit= "MJ/kmol")=-285.8;// Enthalpy of water for the given temp and pressure 


final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";


// Variable Section
Real hf4 (unit= "MJ/kmol")"Total enthalpy in the products side";
Real Q (unit= "MJ/kmol")"Heat transfer per mole of fuel";

// Equation Section

equation

hf4 =(3* hf2 )+(4* hf3 );
Q=hf4 - hf1 ;

end Ex3_6;
