//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth //Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-4: Fuel Air Cycles and Their Analysis
//Example: 4.10 Page 
//======================================================

model Ex4_10
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real r (unit= "")=7.8;
parameter Real p (unit= "atm")=1;
parameter Real T1 (unit= "K")=335;


final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";


// Variable Section
Real W1 (unit= "J/kgK")"Isentropic compression function for T1";
Real W2 (unit= "J/kgK")"Isentropic compression function";
Real T2 (unit= "K")"Temp corrosponding to isentropic compression function";
Real V1 (unit= "m^3/kg")"Volume at initial";
Real p2 (unit= "atm")"Pressure at end of compression stroke";
Real V2 (unit= "m^3/kg")"Volume per unit mass of air at the end of compression stroke";
Real U1 (unit= "kJ/kg")"Internal energy corrosponding to temp T1";
Real U2 (unit= "kJ/kg")"nternal energy corrosponding to temp T2";
Real W (unit= "kJ/kg")"Work input during compression";
Real E1 (unit= "")"Isentropic compression function at T1";
Real E2 (unit= "")"Isentropic compression function at T1";
Real p21 (unit= "atm")"Pressure at end of compression stroke";


// Equation Section

equation

W1 =100; 
W2=W1 -(292*log(1/r));
T2 =645; 
V1 =(292* T1)/(p *10^5) ; 
p2=p*( T2/T1)*r; 
V2=V1/r; 
U1 =35; 
U2 =310; 
W=U2 -U1; 
E1 =120; 
E2 =910; 
p21 =e^((E2-E1)/292);

end Ex4_10;
