//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth //Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-4: Fuel Air Cycles and Their Analysis
//Example: 4.4 Page 
//======================================================

model Ex4_4
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real r (unit= "")=21; 
parameter Real af (unit= "")=29; 
parameter Real T (unit= "K")=1000; 
parameter Real cv (unit= "kJ/kg")=42000; 
parameter Real R (unit= "kJ/kgK")=0.287; 

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";


// Variable Section
Real q23 (unit= "kJ")"Heat transfer during process 2-3";
Real T3 (unit= "K")"Temp during process 2-3";
Real V3 (unit= "")"Ratio of volumes at 2 and 3 points";
Real Vs (unit= "")"Swept volume in terms of V2";
Real V (unit= "")"Difference in volume at 2 and 3 points";
Real pc (unit= "%")"Percentage stroke during which combustion is completed";

// Equation Section

equation
q23 =cv /( af +1) ; 
T3 =( -0.997+(((0.997) ^2) +(4*2411*14e-6) )^(1/2))/(28e-6) ; 
V3 =( T3/T); 
Vs =(r -1) ; 
V=V3 -1; 
pc =(V/Vs) *100; 

end Ex4_4;
