//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth 
//Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-4: Fuel Air Cycles and Their Analysis
//Example: 4.9 Page 
//======================================================

model Ex4_9
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real T (unit= "K")=500; 
parameter Real eq (unit= "")=1; 

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of 
gravity on earth";


// Variable Section
Real Ai (unit= "kg")"Amount of isooctane for 1 kg of air";
Real Ta (unit= "K")"Ambient temp";
Real E (unit= "J/kg")"Isentropic compression function";
Real R (unit= "kJ/kgK")"Gas constant";
Real Ri (unit= "kJ/kgK")"Gas constant for isooctane";
Real W (unit= "kJ/kgK")"Gas constant for isooctane";

//Round off error in book answer

// Equation Section

equation
Ai =0.0662; 
Ta =298; 
E =((0.0662*((0.44*log(T/Ta))+(0.00367*(T-Ta))))+((0.921*log(T/Ta))+(0.000231*(T-Ta))))*1000;
R =8.314; 
Ri=R /114; 
W =(0.5874 -(0.662* Ri*log(T/Ta))-(0.287*log(T/Ta)))*1000;


end Ex4_9;
