//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth //Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-9: Carburettors and Fuel Injection in SI Engines
//Example: 9.9 Page 
//======================================================

model Ex9_9
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real bp (unit= "kW")=8; 
parameter Real nb (unit= "%")=30;
parameter Real CV (unit= "kJ/kg")=44000;
parameter Real p1 (unit= "bar")=1.013;
parameter Real T1 (unit= "K")=300;
parameter Real Aj (unit= "m^2")=2.5e-6;
parameter Real Z (unit= "m")=0.008;
parameter Real A (unit= "")=15;
parameter Real Cda (unit= "")=0.9;
parameter Real Cdf (unit= "")=0.7;
parameter Real df (unit= "kg/m^3")=750;
parameter Real va (unit= "m^3/kg")=0.8;


final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";


// Variable Section
Real va1 (unit= "m^3/kg")"";
Real da (unit= "kg/m^3")"";
Real mf (unit= "kg/s")"";
Real Cf (unit= "m/s")"";
Real P (unit= "N/m^2")"";
Real Ca (unit= "m/s")"";
Real ma (unit= "kg/s")"";
Real A2 (unit= "cm^2")"";
Real d2 (unit= "cm")"";


// Equation Section

equation
va1 =va*T1 /273; 
da =1/ va; 
mf=bp /(( nb /100) *CV ); 
Cf=mf /( Cdf *df*Aj); 
P =(( Cf ^2* df) /2)+( df*g_n*Z); 
Ca =(2* P/da) ^(1/2) ;
ma=mf*A; 
A2 =( ma /( Cda *da*Ca) )*10^4; 
d2 =( A2 *4/ pi) ^(1/2) ; 

end Ex9_9;
