//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth 
//Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-10: CI Engines Fuel Injection System
//Example: 10.7 Page 
//======================================================

model Ex10_7
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real v1 (unit= "m/s")=0.3; 
parameter Real l (unit= "m")=0.575; 
parameter Real A (unit= "")=1/20; 
parameter Real a (unit= "")=1/40; 
parameter Real p1 (unit= "bar")=27.6; 
parameter Real p2 (unit= "")=27.6; 
parameter Real K (unit= "N/m^2")=17830e5; 
parameter Real df (unit= "kg/m^3")=860; 


final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of 
gravity on earth";


// Variable Section
Real Vs (unit= "m/s")"Velocity of pressure disturbance in oil of specific gravity 0.86";
Real t (unit= "s")"Time taken by the disturbance to travel through the pipe line";
Real Vp (unit= "m/s")"Velocity of fuel at inlet of pipe line";
Real p (unit= "bar")"";
Real po (unit= "bar")"";
Real pii (unit= "bar")"";
Real vc (unit= "m/s")"";
Real pr (unit= "bar")"Reflected pressure disturbance";
Real Vc (unit= "m/s")"";
Real po1 (unit= "bar")"";
Real vo (unit= "m/s")"";

// Equation Section

equation
Vs =(K/df) ^(1/2) ; 
t=l/Vs; 
Vp =(1/ A)*v1; 
p =(( K/Vs)*Vp )/10^5; 
pii=p+p1; 
po=p+p1;
vc=Vp -(a *((2*( po -p2))/df) ^(1/2) ); 
pr =26.8;
Vc=pr *( Vs /(K /10^5) ); 
po1 =p1+p+pr; 
vo=a *((2*( po1 -p2) *10^5) /df) ^(1/2) ; 


end Ex10_7;
