//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth 
//Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-11: Two Stroke Engines
//Example: 11.4 Page 
//======================================================

model Ex11_4
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real d (unit= "m")=0.08; 
parameter Real L (unit= "m")=0.1;
parameter Real o (unit= "deg")=60;
parameter Real v (unit= "deg")=60;
parameter Real a (unit= "")=15;
parameter Real re (unit= "")=8;
parameter Real T (unit= "K")=300;
parameter Real p (unit= "bar")=1.05;
parameter Real R (unit= "J/kgK")=290;
parameter Real ma (unit= "kg/h")=150;
parameter Real N (unit= "rpm")=4000;


final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of 
gravity on earth";


// Variable Section
Real mf (unit= "kg/h")"Mass flow rate of fuel";
Real mac (unit= "kg/h")"Actual mass flow rate";
Real r (unit= "cm")"Half length of stroke";
Real Le (unit= "m")"Effective stroke length";
Real Vse (unit= "m^3")"Swept volume corrosponding to Le";
Real V (unit= "m^3")"Total volume ";
Real da (unit= "kg/m^3")"Density";
Real m (unit= "kg/cycle")"Mass of mixture per cycle";
Real mi (unit= "kg/h")"Ideal rate of mass flow";
Real Rsc (unit= "")"Scavenging ratio";
Real nsc (unit= "%")"Scavenging efficiency";
Real ntr (unit= "%")"Trapping efficiency";


// Equation Section

equation
mf=ma/a; 
mac =ma+mf; 
r=(L *100) /2; 
Le =(r+(r*sin(pi/6)))/100;
Vse =( pi*d^2* Le) /4;
V=(re/(re -1) )* Vse ; 
da =(p *10^5) /(R*T); 
m=V*da; 
mi=m *60* N; 
Rsc = mac /mi; 
nsc =(1 -(e^(-Rsc)))*100;
ntr = nsc /Rsc; 

end Ex11_4;

