//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth 
//Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-13: Engine Friction and Lubrication
//Example: 13.1 Page 
//======================================================

model Ex13_1
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real d (unit= "m")=0.08;
parameter Real L (unit= "m")=0.075;
parameter Real l (unit= "m")=0.152;
parameter Real h (unit= "m")=0.062;
parameter Real Fr (unit= "N")=8000;
parameter Real p (unit= "kPa")=3000;
parameter Real y (unit= "m")=0.000004;
parameter Real U (unit= "pa.s")=0.006;
parameter Real u (unit= "m/s")=8.2;
 

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of 
gravity on earth";


// Variable Section
Real ts (unit= "N/m^2")"Shear stress";
Real Area (unit= "m^2")"Contact area beteen the piston and cylinder";
Real Ff (unit= "N")"Friction force on piston";
Real r (unit= "m")"Crank length";
Real A (unit= "radian")"Angle made by crank ";
Real Ft (unit= "N")"Side thrust";

// Equation Section

equation
ts =(U*u)/y; 
Area=pi*d*h; 
Ff=ts*Area; 
r=L/2; 
A=atan(r/l);
Ft=Fr*sin(A);


end Ex13_1;
