//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth 
//Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-13: Engine Friction and Lubrication
//Example: 13.2 Page 
//======================================================

model Ex13_2
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real o (unit= "cm")=0.2;
parameter Real d (unit= "m")=0.065;
parameter Real L (unit= "cm")=6;
parameter Real l (unit= "m")=12;
parameter Real p (unit= "bar")=50;
parameter Real q (unit= "deg")=90; 
parameter Real Ff (unit= "N")=900;

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of 
gravity on earth";


// Variable Section
Real r (unit= "cm")"Crank length";
Real A (unit= "radian")"";
Real Fr (unit= "kN")"Force in connecting rod";
Real Ft (unit= "kN")"Side thrust on piston";
Real A1 (unit= "radian")"";
Real Fr1 (unit= "kN")"Force in connecting rod";
Real Ft1 (unit= "kN")"Side thrust ";
// Equation Section

equation

r=L/2; 
sin(A) =r/l; 
Fr =((( p *10^5*( pi /4) *d ^2) -Ff )/ cos(A) )/1000; 
Ft=Fr* sin(A) ;
sin(A1) =(r-o)/l; 
Fr1 =((( p *10^5*( pi /4)*d ^2) -Ff )/ cos(A1) )/1000; 
Ft1 = Fr1 * sin(A1) ; 

end Ex13_2;
