//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth 
//Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-15: Air Capacity and Supercharging
//Example: 15.2 Page 
//======================================================

model Ex15_2
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real p (unit= "bar")=1.013; 
parameter Real T (unit= "K")=283; 
parameter Real bp (unit= "kW")=275; 
parameter Real N (unit= "rpm")=1800; 
parameter Real a (unit= "")=20; 
parameter Real R (unit= "J/kgK")=287; 
parameter Real bsfc (unit= "kg/kh")=0.24; 
parameter Real nv (unit= "%")=80; 
parameter Real p2 (unit= "bar")=0.75; 
parameter Real P (unit= "%")=9; 
parameter Real T2 (unit= "K")=303; 


final constant Real e=Modelica.Math.exp(1.0);
final constant Real pii=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of 
gravity on earth";


// Variable Section
Real mf (unit= "kg/min")"Mass of fuel consumed";
Real ma1 (unit= "kg/min")"Mass of air used";
Real ma (unit= "kg/cycle")"Actual mass of air taken in per cycle";
Real dai (unit= "kg/m^3")"Density of air";
Real Vd (unit= "m^3")"Volume displaced by piston";
Real pmb (unit= "bar")"Brake mean effective pressure";
Real GP (unit= "kW")"Gross power";
Real ma2 (unit= "kg/min")"Mass flow rate of air for gross power";
Real mA1 (unit= "kg/cycle")"Mass of air required for gross power per cycle";
Real p21 (unit= "bar")"Pressure at outlet conditions of supercharger";
Real pi (unit= "bar")"Increase in air pressure requred in supercharger";



// Equation Section

equation
mf =( bsfc *bp )/60; 
ma1 =mf *(a); 
ma =(2/ N)* ma1 ; 
dai =(p *10^5) /(R*T); 
Vd =( ma /( dai *( nv /100) )); 
pmb =( bp *2*60*1000) /( Vd*N *10^5) ;
GP=bp /(1 -0.09) ; 
ma2 =( ma1 /bp)*GP; 
mA1 =( ma2 *2)/N; 
p21 =(( R*T2* mA1 ) /(( nv /100) *Vd) )/10^5; 
pi=p21 -p2; 

end Ex15_2;
