//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth 
//Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-15: Air Capacity and Supercharging
//Example: 15.3 Page 
//======================================================

model Ex15_3
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real Vs (unit= "m^3")=0.003; 
parameter Real bmep (unit= "bar")=9; 
parameter Real N (unit= "rpm")=4000; 
parameter Real ni (unit= "%")=30; 
parameter Real nm (unit= "%")=90; 
parameter Real bmep1 (unit= "bar")=12; 
parameter Real N1 (unit= "rpm")=4000; 
parameter Real ni1 (unit= "%")=25; 
parameter Real nm1 (unit= "%")=91; 
parameter Real m (unit= "kg")=200; 
parameter Real m1 (unit= "kg")=220; 
parameter Real CV (unit= "kJ/kg")=44000; 


final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of 
gravity on earth";


// Variable Section
Real bp (unit= "kW")"Brake power";
Real ip (unit= "kg/s")"Indicated power";
Real mf (unit= "kW")"Mass flow rate of fuel";
Real bp1 (unit= "kW")"Brake poer for supercharged engine";
Real ip1 (unit= "kW")"Indicated powerfor supercharged engine";
Real mf1 (unit= "kg/s")"Mass flow rate of fuel for supercharged engine per hour";
Real mf2 (unit= "kg/h")"Mass flow rate of fuel for supercharged engine per hour";
Real mf3 (unit= "kg/h")"Mass flow rate of fuel for supercharged engine per hour";
Real x (unit= "hrs")"Max. hours of fuel supply for test";


// Equation Section

equation
bp =( bmep *10^5* Vs*N) /(2*60*1000) ; 
ip=bp /( nm /100) ; 
mf =( ip) /(( ni /100) *CV); 
bp1 =( bmep1 *10^5* Vs*N1) /(2*60*1000) ;
ip1 = bp1 /( nm1 /100) ; 
mf1 = ip1 /(( ni1 /100) *CV); 
mf2 =mf *3600; 
mf3 = mf1 *3600; 
x =((200/90) -(220/120) )/((43.2/120) -(27.27/90) ); 


end Ex15_3;
