//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth //Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-16: Engine Testing and Performance
//Example: 16.11 Page 
//======================================================

model Ex16_11
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real bp (unit= "kW")=30; 
parameter Real mf (unit= "kg/h")=10;
parameter Real CV (unit= "kJ/kg")=42000;
parameter Real mw (unit= "kg/min")=9;
parameter Real Tr (unit= "deg C")=60;
parameter Real mwe (unit= "kg/min")=9.5;
parameter Real Tc (unit= "deg C")=40;
parameter Real Te (unit= "deg C")=80;
parameter Real a (unit= "")=20;
parameter Real T (unit= "deg C")=17;
parameter Real Cpw (unit= "kJ/kgK")=4.18;
parameter Real Cpg (unit= "kJ/kgK")=1;


final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";


// Variable Section
Real Qf (unit= "kJ/min")"Heat supplied by fuel";
Real Qbp (unit= "kJ/min")"Heat equivalent to bp";
Real Qc (unit= "kJ/min")"Heat carried away by the jacket cooling water";
Real mg (unit= "kg/min")"Mass of exhaust gas formed";
Real Qe (unit= "kJ/min")"Heat carried away by exhaust gases";
Real Qu (unit= "kJ/min")"Unaccounted heat";
Real x (unit= "bp")"% heat of cooling water";
Real y (unit= "%")"% loss of heat to exhaust gases";
Real z (unit= "%")"% loss of heat to exhaust gases";
Real k (unit= "%")"% heat loss unaccounted";


// Equation Section

equation

Qf =( mf /60) *CV;
Qbp =bp *60; 
Qc=mw* Cpw *Tr; 
mg =( mf /60) +( mf /60) *a;
Qe =( mwe* Cpw *Tc)+( mg* Cpg *(Te -T)); 
Qu=Qf -( Qbp +Qc+Qe); 
x =(( Qbp/Qf)) *100;
y=( Qc/Qf) *100; 
z=( Qe/Qf) *100; 
k=( Qu/Qf) *100; 

end Ex16_11;
