//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth //Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-16: Engine Testing and Performance
//Example: 16.8 Page 
//======================================================

model Ex16_8
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real d (unit= "m")=0.2; 
parameter Real L (unit= "m")=0.3; 
parameter Real r (unit= "")=5.5; 
parameter Real N (unit= "rpm")=400; 
parameter Real imep (unit= "bar")=4.5; 
parameter Real a (unit= "")=6; 
parameter Real CV (unit= "kJ/m^3")=12000; 
parameter Real T (unit= "K")=340; 
parameter Real p (unit= "bar")=0.97; 
parameter Real g (unit= "")=1.4; 


final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";


// Variable Section
Real Vs (unit= "m^3")"Swept volume";
Real Vc (unit= "m^3")"Clearance volume";
Real V (unit= "m^3")"Total cylinder volume";
Real Vg (unit= "m^3")"Volume of gas in total cylinder volume";
Real Vntp (unit= "m^3")"Volume of gas at NTP";
Real Q (unit= "kJ/s")"Heats supplied by fuel";
Real ip (unit= "kW")"Indicated power";
Real ni (unit= "%")"Indicated thermal efficiency";
Real na (unit= "%")"Air standard efficiency";
Real nr (unit= "%")"Relative efficiency based on indicated thermal efficiency";


// Equation Section

equation
Vs =( pi /4) *d ^2* L; 
Vc=Vs /(r -1) ; 
V=Vs+Vc; 
Vg=V/7; 
Vntp =((p*Vg)/T) *(273/1.013) ; 
Q= Vntp *CV *(N /(2*60) ); 
ip =( imep *10^5* L*( pi /4) *d ^2*( N /(2*60) ) *(1/1000) ); 
ni =( ip/Q) *100; 
na =(1 -(1/ r)^(g -1) )*100; 
nr =( ni/na) *100; 

end Ex16_8;
