//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth 
//Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-02: Air Standard Cycles and their Analysis
//Example: 02.9 Page 
//======================================================

model Ex2_9
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real r (unit= "")=12; //Compression ratio
parameter Real B (unit= "")=1.615; // Cut off ratio
parameter Real p3 (unit= "bar")=52.17; //Maximum pressure
parameter Real p4 (unit= "bar")=52.17;// Maximum pressure 
parameter Real p1 (unit= "bar")=1; //Initial pressure
parameter Real T1 (unit= "K")=335; //Initial temperature
parameter Real n (unit= "")=1.35; //Indices of compression and expansion
parameter Real g (unit= "")=1.4; //Adiabatic exponent
parameter Real mR (unit= "kJ/kgK")=0.287; //Real gas constant
parameter Real Cv (unit= "kJ/kgK")=0.718; //Specific heat at constant volume for air
parameter Real Cp (unit= "kJ/kgK")=1.005; //Specific heat at constant pressure for air


final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of 
gravity on earth";


// Variable Section
Real T2 (unit= "K")"Temperature at point 2";
Real p2 (unit= "bar")"Pressure at point 2";
Real T3 (unit= "K")"Temperature at point 3";
Real T4 (unit= "K")"Temperature at point 4";
Real T5 (unit= "K")"Temperature at point 5";
Real Q12 (unit= "kJ/kg")"Heat trasnfer during process 1-2 for unit mass";
Real Q23 (unit= "kJ/kg")"Heat trasnfer during process 2-3 for unit mass";
Real Q34 (unit= "kJ/kg")"Heat trasnfer during process 3-4 for unit mass";
Real Q45 (unit= "kJ/kg")"Heat trasnfer during process 4-5 for unit mass";
Real Q51 (unit= "kJ/kg")"Heat trasnfer during process 5-1 for unit mass";
Real Q1 (unit= "kJ/kg")"Heat supplied";
Real Q2 (unit= "kJ/kg")"Heat rejected";
Real W (unit= "kJ/kg")"Work done";
Real E (unit= "")"Efficiency in %";
Real Vs (unit= "m^3/kg")"Swept volume for unit mass";
Real pm (unit= "bar")"Mean effective pressure";


// Equation Section

equation
T2=T1*r^(n -1) ; 
p2=p1 *(r)^n; 
T3=T2 *( p3/p2); 
T4=T3*B; 
T5=T4 *(B/r)^(n -1);
Q12 =((g-n)/(g -1) )* mR *(( T1 -T2)/(n -1) ); 
Q23 =Cv *(T3 -T2); 
Q34 =Cp *(T4 -T3); 
Q45 =((g-n)/(g -1) )*mR *(( T4 -T5)/(n -1) );
Q51 =Cv *(T1 -T5); 
Q1=Q23+ Q34 + Q45 ; 
Q2=-Q12 +(- Q51 ); 
W=Q1 -Q2; 
E=(W/Q1)*100; 
Vs =(( mR*T1)/p1 )*(r -1) /r; 
pm =(W / Vs ); 
end Ex2_9;
