//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth //Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-03: Reactive Systems
//Example: 03.1 Page 
//======================================================

model Ex3_1
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real E (unit= "")=20; //Methanol burned with excess air in percentage
parameter Real p (unit= "bar")=1;//Pressure of air in bar
parameter Real t (unit= "deg C")=27;// Temperature of air 
parameter Real O (unit= "")=32;// Molecular weight of oxygen
parameter Real N (unit= "")=28;//Molecular weight of nitrogen
parameter Real R (unit= "Nm/kmolK")=8314;//Universal gas constant
parameter Real C (unit= "")=32;//Molecular weight of methanol
parameter Real CO (unit= "")=44;// Molecular weight of carbondioxide
parameter Real H (unit= "")=18;//Molecular weight of water
parameter Real D (unit= "deg C")=60;//De point is the saturation temp corrosponding to partial pressure 


final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";


// Variable Section
Real S (unit= "")"Stoichiometric air/fuel ratio";
Real A (unit= "")"Actual air/fuel ratio";
Real M (unit= "kmol")"1 kmole of fuel reacts ith air in kmole";
Real V (unit= "m^3/kmol")"Volume of air in m^3/kmole fuel";
Real T (unit= "")"Total number of moles in the reactants when excess air is supplied in moles";
Real Cm (unit= "")"Mole fraction of methanol";
Real Om (unit= "")"Mole fraction of oxygen";
Real Nm (unit= "")"Mole fraction of nitrogen";
Real Mr (unit= "")"Molecular weight of reactants";
Real Tp (unit= "moles")"Total number moles in the product ";
Real COm (unit= "")"Mole fraction of carbondioxide";
Real Hp (unit= "")"Mole fraction of water";
Real Np (unit= "")"Mole fraction of nitrgen";
Real Op (unit= "")"Mole fraction of oxygen";
Real Mp (unit= "")"Molecular weight of products";
Real Pp (unit= "bar")"Partial pressure of water vapour";


// Equation Section

equation
S =((1.8* O) +(6.768* N))/C; 
A =((1.8* O) +(6.768* N))/C; 
M =1.8+6.768; 
V=(M*R*(t +273) )/(p *10^5) ; 
T =(1+1.8+6.768) ; 
Cm =(1/ T); 
Om =(1.8/ T); 
Nm =(6.768/ T); 
Mr =( Cm*C)+( Om*O)+( Nm*N); 
Tp =(1+2+6.768+0.3) ; 
COm =(1/ Tp); 
Hp =(2/ Tp); 
Np =(6.768/ Tp); 
Op =(0.3/ Tp); 
Mp =( COm*CO)+( Hp*H)+( Np*N)+( Op*O); 
Pp =( Hp*p);

end Ex3_1;
