//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth //Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-03: Reactive Systems
//Example: 03.16 Page 
//======================================================

model Ex3_16
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real T (unit= "K")=600; 
parameter Real p (unit= "atm")=1; 
parameter Real E (unit= "%")=50; 
parameter Real L (unit= "%")=20; 
parameter Real cp (unit= "kJ/kmolK")=52.234; 
parameter Real T11 (unit= "K")=298; 

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";


// Variable Section
Real hfch (unit= "MJ")"Enthalphy of formation for CO2";
Real hch (unit= "MJ")"Change in enthalphy for CO2";
Real ho (unit= "MJ")"Change in enthalphy for oxygen";
Real hn (unit= "MJ")"Change in enthalphy for nitrogen";
Real HR (unit= "MJ")"Total enthalphy on reactants side";
Real hfc1 (unit= "MJ")"Enthalphy of formation for CO2";
Real hfh1 (unit= "MJ")"Enthalphy of formation for water";
Real HP (unit= "MJ")"Enthalphy of products side";
Real x (unit= "MJ")"Change in enthalphy for remaining";
Real hn2  (unit= "MJ")"Enthalphy of nitrogen assumed to be";
Real Tc (unit= "K")"Corrosponding temp";
Real T1 (unit= "K")"Temp for second trail";
Real hfc11 (unit= "MJ")"Change in enthalphy for assume temp for CO2";
Real hfh11 (unit= "MJ")"Change in enthalphy for assume temp for water";
Real hfn11 (unit= "MJ")"Change in enthalphy for assume temp for nitrogen";
Real hfo11 (unit= "MJ")"Change in enthalphy for assume temp for oxygen";
Real HP1 (unit= "MJ")"Total enthalphy on products side for first trail";
Real T2 (unit= "K")"Temp for second trail";
Real hfc22 (unit= "MJ")"Enthalphy for assume temp for CO2";
Real hfh22 (unit= "MJ")"Change in enthalphy for assume temp for water";
Real hfn22 (unit= "MJ")"Change in enthalphy for assume temp for nitrogen";
Real hfo22 (unit= "MJ")"Change in enthalphy for assume temp for oxygen";
Real HP2 (unit= "MJ")"Total enthalphy on products side";
Real Ta1 (unit= "K")"Adiabatic temp for constant pressure process";
Real X (unit= "MJ")"By balance oxygen";
Real hfchr (unit= "MJ")"Enthalphy of formation for CH4";
Real hor (unit= "MJ")"Change in enthalphy for oxygen";
Real hnr (unit= "MJ")"Change in enthalphy for nitrogen";
Real HRr (unit= "MJ")"Total enthalphy on reactants side";
Real hfcop (unit= "MJ")"Enthalphy of formation for CO";
Real hfcp (unit= "MJ")"Enthalphy of formation for CO2";
Real hfhp (unit= "MJ")"Enthalphy of formation for water";
Real HPp (unit= "MJ")"Enthalphy on product side";
Real Tp1 (unit= "K")"Temp for first trail";
Real hco11 (unit= "MJ")"Change in enthalphy for CO";
Real hco211 (unit= "MJ")"Change in enthalphy for CO2";
Real hh11 (unit= "MJ")"Change in enthalphy for water";
Real hn11 (unit= "MJ")"Change in enthalphy for nitrogen";
Real HPp1 (unit= "MJ")"Enthalphy on products side";
Real Tp2 (unit= "K")"Temp for second trail";
Real hco22 (unit= "MJ")"Change in enthalphy for CO";
Real hco222 (unit= "MJ")"Change in enthalphy for CO2";
Real hh22 (unit= "MJ")"Change in enthalphy for water";
Real hn22 (unit= "MJ")"Change in enthalphy for nitrogen";
Real HPp2 (unit= "MJ")"Enthalphy on products side for trail temp";
Real Tp3  (unit= "K")"Temp for third trail";
Real hco33 (unit= "MJ")"Change in enthalphy for CO";
Real hco233 (unit= "MJ")"Change in enthalphy for CO2";
Real hh33 (unit= "MJ")"Change in enthalphy for water";
Real hn33 (unit= "MJ")"Change in enthalphy for nitrogen";
Real HPp3 (unit= "MJ")"Enthalphy on products side for trail temp";
Real Ta2 (unit= "K")"Adiabatic temp for constant pressure process";
Real hccc (unit= "MJ/kmol")"Only combustible substance is CO";
Real Q (unit= "MJ/kmol")"Thermal energy loss";

// Equation Section

equation
hfch = -74.87; 
hch =cp *(T-T1)/1000; 
ho =9.247; 
hn =8.891; 
HR= hfch + hch +(3* ho) +(11.28* hn); 
hfc1 = -393.52; 
hfh1 = -241.82; 
HP= hfc1 +(2* hfh1 ); 
x=HR -HP; 
hn2 =x /11.28; 
Tc =2800; 
T1 =2000; 
hfc11 =91.45; 
hfh11 =72.689;
hfn11 =56.141; 
hfo11 =59.199; 
HP1 = hfc11 +(2* hfh11 ) +(11.28* hfn11 )+( hfo11 )+(HR -x); 
T2 =2100; 
hfc22 =97.5; 
hfh22 =77.831; 
hfn22 =59.748; 
hfo22 =62.986; 
HP2 = hfc22 +(2* hfh22 ) +(11.28* hfn22 )+( hfo22 )+(HR -x); 
Ta1 =((( HR - HP1 )/( HP2 - HP1 ) )*( T2 -T1))+ T1; 
X =2*(2 -1.6); 
hfchr = -74.87; 
hor =9.247; 
hnr =8.891; 
HRr = hfchr + hch +(1.6* hor) +(6.01* hnr); 
hfcop = -110.52; 
hfcp = -393.52; 
hfhp = -241.82; 
HPp =(0.8* hfcop ) +(0.2* hfcp ) +(2* hfhp ); 
Tp1 =2000; 
hco11 =56.739; 
hco211 =91.45; 
hh11 =72.689; 
hn11 =56.141; 
HPp1 =(0.8* hco11 ) +(0.2* hco211 ) +(2* hh11 ) +(6.016* hn11 )-HPp; 
Tp2 =2400; 
hco22 =71.34; 
hco222 =115.788; 
hh22 =93.604; 
hn22 =70.651; 
HPp2 =(0.8* hco22 ) +(0.2* hco222 ) +(2* hh22 ) +(6.016* hn22 )+HPp ; 
Tp3 =2300; 
hco33 =67.676; 
hco233 =109.671; 
hh33 =88.295; 
hn33 =67.007; 
HPp3 =(0.8* hco33 ) +(0.2* hco233 ) +(2* hh33 ) +(6.016* hn33 )+HPp ; 
Ta2 =((( HRr - HPp3 )/( HPp2 - HPp3 ))*( Tp2 - Tp3 ))+ Tp3 ;
hccc = -283.022; 
Q = -0.8* hccc ; 

end Ex3_16;
