//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth //Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-03: Reactive Systems
//Example: 03.2 Page 
//======================================================

model Ex3_2
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real C1 (unit= "%")=40;//Content of C7H16 in the fuel 
parameter Real C2(unit= "%")=60;//Content of C8H18 in the fuel
parameter Real d (unit= "m")=0.12;// Daimeter of bore
parameter Real l (unit= "m")=0.145;//Length of bore
parameter Real r (unit= "")=8.5;// Compression ratio
parameter Real p (unit= "bar")=1.1;//Pressure at exhaust stroke
parameter Real T (unit= "K")=720;//Temperature at exhaust stroke
parameter Real O (unit= "")=32;// Molecular weight of oxygen
parameter Real N (unit= "")=28;//Molecular weight of nitrogen
parameter Real R (unit= "Nm/kmolK")=8314;//Universal gas constant
parameter Real C3 (unit= "")=100;//Molecular weight of C7H16
parameter Real C4 (unit= "")=114;//Molecular weight of C8H18
parameter Real C5 (unit= "")=32;//Molecular weight of carbonmonoxide
parameter Real CO2 (unit= "")=44;// Molecular weight of carbondioxide
parameter Real H (unit= "")=18;//Molecular weight of water

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";


// Variable Section
Real N2 (unit= "%")"Percentage of nitrogen in the dry products of combustion";
Real Y (unit= "moles")"Number of moles of oxygen supplied";
Real X (unit= "moles")"Moles of carbon";
Real Z (unit= "moles")"Number of moles of hydrogen";
Real Hl (unit= "moles")"Number of moles of hydrogen in L.H.S";
Real Hr (unit= "moles")"Number of moles of hydrogen in R.H.S";
Real Hd (unit= "moles")"Difference of hydrogen moles";
Real A (unit= "")"Air/fuel ratio";
Real Vs (unit= "m^3")"Swept volume of cylinder";
Real Vc (unit= "m^3")"Clearance ratio";
Real M (unit= "")"Molecular weight of the product";
Real R1 (unit= "J/kgK")"Gas constant";
Real m (unit= "kg")"Mass of exhaust gases in the clearance space ";


// Equation Section

equation
N2 =100 -(12+1.5+2.5) ; 
Y =84/3.76; 
X =13.5/7.6; 
Z =(22.34 -15.25) *2; 
Hl =(6.4+10.8) /2; 
Hr =7.98; 
Hd=Hl -Hr; 
A =((12.58*( O +(3.76* N)) )/((( C1 /100) *C3) +(( C2 /100) *C4)));
Vs =( pi /4) *d ^2* l; 
Vc=Vs /(r -1) ; 
M =((6.757* CO2 ) +(0.8446* C5) +(1.408* O) +(47.3* N) +(8.6* H) )/(6.757+0.8446+1.408+47.3+8.6); 
R1=R/M; 
m =(( p *10^5) *Vc )/(R1*T); 


end Ex3_2;
