//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth //Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-03: Reactive Systems
//Example: 03.4 Page 
//======================================================

model Ex3_4
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real CO (unit= "%")=12; //Composition of carbondioxide of combustion by volume
parameter Real C (unit= "%")=0.5; //Composition of carbonmoxide of combustion by volume
parameter Real O (unit= "%")=4; //Composition of oxygen of combustion by volume
parameter Real N (unit= "%")=83.5; 
parameter Real o (unit= "%")=32; //Molecular weight of oxygen
parameter Real co (unit= "")=44; //Molecular weight of carbodioxide
parameter Real c (unit= "")=12;//Molecular weight of  carbon
parameter Real s (unit= "")=32; //Molecular weight of sulphur 
parameter Real so (unit= "")=64; //Molecular weight of sulphur dioxide
parameter Real n1 (unit= "")=28;//Molecular weight of  nitrogen
parameter Real h (unit= "")=2;//Molecular weight of  hydrogen

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";


// Variable Section
Real m (unit= "")"Balancing carbon";
Real x (unit= "")"Balancing nitrogen";
Real z (unit= "")"Balancing oxygen";
Real n (unit= "")"Balancing hydrogen";
Real Af (unit= "")"Air/fuel ratio";
Real As (unit= "")"Stoichiometric air/fuel ratio";
Real Ta (unit= "")"Percent theoritical air ";
Real mc (unit= "%")"Composition of carbon on mass basis";
Real mh (unit= "%")"Composition of hydrogen on mass basis";


// Equation Section

equation
m =12+0.5; 
x=N /3.76; 
z=(x -( CO +(C /2) +O) )*2; 
n=z*h; 
Af =((x*o)+(N*n1) )/(( m*c)+(n)); 
As =((18.46* o) +(69.41* n1) )/173.84; 
Ta =( Af/As) *100;
mc =((m*c) /173.84)*100; 
mh =(n /173.84) *100; 

end Ex3_4;
