//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth //Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-03: Reactive Systems
//Example: 03.5 Page 
//======================================================

model Ex3_5
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
 
parameter Real C (unit= "%")=86; //Composition of carbon in fuel by weight
parameter Real H (unit= "%")=14; //Composition of hydrogen in fuel by weight
parameter Real o (unit= "%")=32; //Molecular weight of oxygen
parameter Real co (unit= "")=44; //Molecular weight of carbodioxide
parameter Real c (unit= "")=12;//Molecular weight of  carbon
parameter Real s (unit= "")=32; //Molecular weight of sulphur 
parameter Real so (unit= "")=64; //Molecular weight of sulphur dioxide
parameter Real n (unit= "")=28;//Molecular weight of  nitrogen
parameter Real h2 (unit= "")=2;//Molecular weight of  hydrogen
parameter Real Fc (unit= "")=0.86;// Fraction of C

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";


// Variable Section
Real Ra (unit= "")"Relative air/fuel ratio";
Real x (unit= "")"By oxygen balance";
Real Tm (unit= "moles")"Total number of moles of dry exhaust gas";
Real vc (unit= "%")"Volumetric analysis of carbonmonoxide of combustion";
Real vco (unit= "%")"Volumetric analysis of carbondioxide of combustion";
Real vn (unit= "%")"Volumetric analysis of nitrogen of combustion";


// Equation Section

equation
Ra =1/ Fc; 
x =2*(1+(0.9765/2) -(1.488*0.8) ); 
Tm =0.5957+0.4043+4.476; 
vc =(0.5957/ Tm) *100; 
vco =(0.4043/ Tm) *100; 
vn =(4.476/ Tm) *100; 

end Ex3_5;
