//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth //Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-03: Reactive Systems
//Example: 03.7 Page 
//======================================================

model Ex3_7
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real t (unit= "deg C")=25;//Temp of air entering the diesal engine
parameter Real T (unit= "K")=600;//Temp at which products are released
parameter Real Ta (unit= "%")=200;//Theoritical air used
parameter Real Q (unit= "MJ/kmol")=-93;//Heat loss from the engine
parameter Real f (unit= "kmol/h")=1;//Fuel rate

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";


// Variable Section
Real hfr (unit= "MJ/kmol")"Enthalpy of C12H26 for the given conditions in the reactants side";
Real h1 (unit= "MJ/kmol")"Enthalpy of carbondioxide at formation state";
Real h11 (unit= "MJ/kmol")"Change in enthalpy for the given temp of CO2";
Real hfc (unit= "MJ/kmol")"Enthalpy of carbondioxide";
Real h2 (unit= "MJ/kmol")"Enthalpy of water at formation state";
Real h22 (unit= "MJ/kmol")"Change in enthalpy for the given temp of water";
Real hfh (unit= "MJ/kmol")"Enthalpy of water";
Real h3 (unit= "MJ/kmol")"Enthalpy of oxygen gas";
Real h33 (unit= "MJ/kmol")"Change in enthalpy for the given temp of oxygen";
Real hfo (unit= "MJ/kmol")"Enthalpy of oxygen";
Real h4 (unit= "MJ/kmol")"Enthalpy of nitrogen gas";
Real h44 (unit= "MJ/kmol")"Change in enthalpy of nitrogen fot the given temp";
Real hfn (unit= "MJ/kmol")"Enthalpy of nitrogen";
Real hfp (unit= "MJ/kmol")"Total enthalpy of products side";
Real W (unit= "MJ/kmol")"Work";
Real W1 (unit= "kW")"Work";


// Equation Section

equation
hfr = -290.97; 
h1 = -393.52; 
h11 =12.916; 
hfc =h1+h11; 
h2 = -241.82;
h22 =10.498; 
hfh =h2+h22; 
h3 =0; 
h33 =9.247; 
hfo =h3+h33; 
h4 =0;
h44 =8.891;
hfn =h4+h44; 
hfp =(12* hfc) +(13* hfh) +(18.5* hfo) +(139.12* hfn ); 
W=Q+hfr - hfp ;
W1 =(f*W *10^3) /3600;

end Ex3_7;
