//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth 
//Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-4: Fuel Air Cycles and Their Analysis
//Example: 4.1 Page 
//======================================================

model Ex4_1
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real r (unit= "")=8.5; 
parameter Real sv (unit= "%")=1.4;

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of 
gravity on earth";


// Variable Section
Real n (unit= "")"Efficiency of Otto cycle";
Real ef (unit= "")"% change in efficiancy of an Otto cycle and is negative";

// Equation Section

equation
n =1 -(1/r)^(sv -1) ; 
ef =(((1 - n)/n)*(sv -1) *(log(r))*(sv/100))*100;


end Ex4_1;
