//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth //Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-4: Fuel Air Cycles and Their Analysis
//Example: 4.11 Page 
//======================================================

model Ex4_11
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real p (unit= "bar")=65; 
parameter Real r (unit= "")=10; 
parameter Real V3 (unit= "m^3/kg")=0.1; 
parameter Real p3 (unit= "kN/m^2")=6500; 

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";


// Variable Section
Real T3 (unit= "K")"Temp from chart";
Real u3 (unit= "kJ/kg")"Energy from chart";
Real s3 (unit= "kJ/kg")"Entropy from chart";
Real s4 (unit= "kJ/kg")"Since process is isentropic";
Real V4 (unit= "m^3/kg")"Volume per unit mass of air at the end of expansion stroke";
Real T4 (unit= "K")"Temp from the chart corrosponding to p4.V4";
Real u4 (unit= "kJ/kg")"Energy from chart";
Real p4 (unit= "bar")"Pressure from chart";
Real W (unit= "kJ/kg")"Work of expansion";


// Equation Section

equation
T3 =2240; 
u3 = -1040; 
s3 =8.87; 
s4=s3; 
V4=r*V3; 
T4 =1280; 
u4 = -2220; 
p4 =4.25; 
W=-(u4 -u3); 

end Ex4_11;
