//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth //Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-9: Carburettors and Fuel Injection in SI Engines
//Example: 9.1 Page 
//======================================================

model Ex9_1
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real ma (unit= "kg/min")=5; 
parameter Real mf (unit= "kg/min")=0.4;
parameter Real df (unit= "kg/m^3")=780;
parameter Real p1 (unit= "bar")=1.013;
parameter Real t1 (unit= "deg C")=27;
parameter Real C2 (unit= "m/s")=90;
parameter Real Cva (unit= "")=0.8;
parameter Real Cdf (unit= "")=0.6;
parameter Real Cpd (unit= "")=0.75;
parameter Real Cp (unit= "J/kgK")=1005;
parameter Real g (unit= "")=1.4;
parameter Real R (unit= "J/kgK")=287;


final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";


// Variable Section
Real p2 (unit= "bar")"Throat pressure";
Real da1 (unit= "kg/m^3")"Density of air";
Real da2 (unit= "kg/m^3")"Density of air at throat";
Real A2 (unit= "cm")"Throat area";
Real d2 (unit= "cm")"Throat diameter of choke";
Real pv (unit= "bar")"Pressure drop at venturi";
Real pj (unit= "bar")"Pressure drop at jet";
Real Aj (unit= "mm^2")"Area of jet";
Real dj (unit= "mm")"Orifice diameter";


// Equation Section

equation
p2=p1 *(1 -( C2 ^2/( Cva ^2*2* Cp *( t1 +273) )) )^( g/(g -1)); 
da1 =(( p1 *10^5) /(R*( t1 +273) )); 
da2 =(( da1)*( p2/p1) ^(1/ g)); 
A2 =(( ma /60) /( da2*C2) )*10^4; 
d2 =(4* A2/pi) ^(1/2) ; 
pv=p1 -p2; 
pj=Cpd*pv; 
Aj =(( mf /60) /( Cdf *(2* df*pj *10^5) ^(1/2) ) )*10^6;
dj =(4* Aj/pi) ^(1/2) ; 

end Ex9_1;
