//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth //Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-9: Carburettors and Fuel Injection in SI Engines
//Example: 9.3 Page 
//======================================================

model Ex9_3
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real d (unit= "m")=0.08; 
parameter Real L (unit= "m")=0.09; 
parameter Real N (unit= "rpm")=4000; 
parameter Real C (unit= "%")=84; 
parameter Real H (unit= "%")=16; 
parameter Real nv (unit= "%")=80; 
parameter Real p1 (unit= "bar")=1; 
parameter Real t1 (unit= "deg C")=25; 
parameter Real p (unit= "bar")=0.06; 
parameter Real ma (unit= "")=0.95; 
parameter Real Ra (unit= "J/kgK")=287; 
parameter Real Rf (unit= "J/kgK")=98; 
parameter Real n (unit= "")=4; 
parameter Real Cp (unit= "J/kgK")=1005; 
parameter Real g (unit= "")=1.4; 


final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";


// Variable Section
Real V (unit= "m^3/s")"Volume mixture to engine";
Real Af (unit= "")"Stioichiometric air/fuel ratio";
Real mfa (unit= "kg/kg fuel")"Actual mass of air supplied per kg of fuel";
Real Aaf (unit= "kg/m^3")"Actual air fuel ratio";
Real da (unit= "kg/m^3")"Density of air at one bar";
Real dv (unit= "kg/m^3")"Density of fuel vapour";
Real ma1 (unit= "kg/s")"Mass flow rate of air";
Real mf1 (unit= "kg/s")"Mass flow rate of fuel";
Real p2 (unit= "bar")"Pressure at outlet";
Real C2 (unit= "m/s")"Velocity of air at throat";
Real T2 (unit= "K")"Temp at throat";
Real den2 (unit= "kg/m^3")"Density of air at throat";
Real A2 (unit= "cm^2")"Cross sectional area of venturi throat";
Real d2 (unit= "cm")"Diameter of venturi throat";


// Equation Section

equation
V=( pi /4)*d ^2* L*( nv /100) *(N /(2*60) )*n; 
Af =(100/23) *(( C *(32/12) )+(H *8) ) /100; 
mfa =Af*ma; 
Aaf = mfa ; 
da =( p1 *10^5) /( Ra *( t1 +273) ); 
dv =( p1 *10^5) /( Rf *( t1 +273) ); 
ma1 =V /((1/ da) +(1/( mfa*dv))); 
mf1 = ma1 /mfa; 
p2=p1 -p; 
C2 =(2* Cp *( t1 +273) *(1 -( p2/p1) ^((g -1)/g)) )^(1/2) ; 
T2 =( t1 +273) *( p2/p1) ^((g -1)/g);
den2 =( p2 *10^5) /( Ra*T2); 
A2 =( ma1 /( den2*C2) )*10^4; 
d2 =( A2 *4/ pi) ^(1/2) ; 

end Ex9_3;
