//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth //Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-9: Carburettors and Fuel Injection in SI Engines
//Example: 9.4 Page 
//======================================================

model Ex9_4
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real d (unit= "m")=0.1; 
parameter Real L (unit= "m")=0.12;
parameter Real N (unit= "rpm")=3000;
parameter Real d2 (unit= "m")=0.035;
parameter Real nv (unit= "%")=80;
parameter Real Cda (unit= "")=0.82;
parameter Real p (unit= "bar")=1.013;
parameter Real T (unit= "K")=298;
parameter Real ar (unit= "")=15;
parameter Real Z (unit= "m")=0.005;
parameter Real Cdf (unit= "")=0.7;
parameter Real df (unit= "kg/m^3")=750;
parameter Real R (unit= "J/kgK")=287;
parameter Real n (unit= "")=4;

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";


// Variable Section
Real V (unit= "m^3/s")"Volume of air inducted per second";
Real da (unit= "kf/m^3")"Density of air";
Real ma (unit= "kg/s")"Mass flow rate of air";
Real A2 (unit= "m^2")"Area of throat";
Real P (unit= "bar")"Change in pressure";
Real mf (unit= "kg/s")"Mass flow rate of fuel";
Real Aj (unit= "mm^2")"Area of fuel jet";
Real dj (unit= "mm")"Diameter of fuel jet of simple carburator";


// Equation Section

equation
V=( pi /4)*d ^2* L*( nv /100) *(N /(2*60) )*n; 
da =(p *10^5) /(R*T); 
ma=V*da; 
A2 =( pi /4) *d2 ^2;
P=( ma ^2/( Cda ^2* A2 ^2*2* da) )/10^5; 
mf=ma/ar; 
Aj =( mf /( Cdf *(2* df *(( P *10^5) -(g_n*Z*df))) ^(1/2) ) )*10^6;
dj =( Aj *4/ pi) ^(1/2) ; 

end Ex9_4;
