//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth 
//Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-10: CI Engines Fuel Injection System
//Example: 10.2 Page 
//======================================================

model Ex10_2
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real bp (unit= "kW")=30; 
parameter Real N (unit= "rpm")=3000; 
parameter Real bsfc (unit= "kg/kWh")=0.28; 
parameter Real API (unit= "")=35; 
parameter Real p2 (unit= "bar")=160; 
parameter Real CA (unit= "deg")=28; 
parameter Real p1 (unit= "bar")=35; 
parameter Real Cv (unit= "")=0.92; 


final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of 
gravity on earth";


// Variable Section
Real S (unit= "")"Specific gravity";
Real df (unit= "kg/m^3")"Density of fuel";
Real D (unit= "s")"Duration of injection";
Real F (unit= "kg")"Fuel condumption per cycle";
Real mf (unit= "kg/s")"Mass flow rate of fuel";
Real Cf (unit= "m/s")"Velocity of injection of fuel";
Real Af (unit= "mm^2")"Area of fuel orifice";
Real d (unit= "mm")"Diameter of orifice";


// Equation Section

equation
S =141.5/(131.5+ API);
df=S *1000; 
D=( CA /360) /(N /60) ; 
F=( bsfc *bp) /(( N/2) *60) ;
mf=F/D; 
Cf=Cv *((2*( p2 -p1) *10^5) /df) ^(1/2) ; 
Af =( mf /( df*Cf) )*10^6; 
d =(4* Af/pi) ^(1/2) ; 

end Ex10_2;
