//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth 
//Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-10: CI Engines Fuel Injection System
//Example: 10.5 Page 
//======================================================

model Ex10_5
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real v (unit= "cc")=6.5; 
parameter Real d (unit= "cm")=0.3;
parameter Real l (unit= "cm")=65; 
parameter Real vi (unit= "cc")=2.5; 
parameter Real K (unit= "bar")=78.5e-6; 
parameter Real p1 (unit= "bar")=1; 
parameter Real p2 (unit= "bar")=180; 
parameter Real v3 (unit= "cc")=0.1; 
parameter Real ee (unit= "cm")=0.75; 


final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of 
gravity on earth";


// Variable Section
Real V1 (unit= "cc")"Total initial volume";
Real V (unit= "cc")"Change in volume due to compression";
Real T (unit= "cc")"Total displacement of plunger";
Real L (unit= "cm")"Effective stroke of plunger";


// Equation Section

equation
V1=v+(( pi*d ^2) /4)*l+vi; 
V=K*V1 *(p2 -p1); 
T=(V)+v3; 
L=T *(4/ pi) *(1/( ee^2)); 

end Ex10_5;
