//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth 
//Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-11: Two Stroke Engines
//Example: 11.1 Page 
//======================================================

model Ex11_1
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real nsc (unit= "%")=75; 
parameter Real ns (unit= "%")=20; 

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of 
gravity on earth";


// Variable Section
Real Rsc (unit= "")"Scavenging ratio for normal efficiency";
Real nsc1 (unit= "")"For 20% increase in scavenging efficiency";
Real Rsc1 (unit= "")"Scavenging ratio for 20%";
Real Rscr (unit= "%")"% increase in scavenging ratio";


// Equation Section

equation
Rsc =log(1/(1-(nsc/100)));
nsc1 =( nsc /100) +(( nsc /100) *( ns /100) );  
Rsc1 =log(1/(1-(nsc1)));
Rscr =(( Rsc1 - Rsc )/Rsc )*100; 

end Ex11_1;
