//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth 
//Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-11: Two Stroke Engines
//Example: 11.2 Page 
//======================================================

model Ex11_2
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real d (unit= "m")=0.12; 
parameter Real l (unit= "m")=0.15; 
parameter Real r (unit= "")=16; 
parameter Real N (unit= "rpm")=2000; 
parameter Real mf (unit= "kg/min")=240/60; 
parameter Real T (unit= "K")=300; 
parameter Real p (unit= "bar")=1.025; 
parameter Real R (unit= "J/kg")=287; 


final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of 
gravity on earth";


// Variable Section
Real da (unit= "kg/m^3")"Density of air";
Real Vs (unit= "m^3")"Swept volume";
Real V (unit= "m^3")"Total cylinder volume";
Real m (unit= "kg per cycle")"Ideal mass in total cylinder volume";
Real m1 (unit= "kg/min")"Ideal mass per unit time";
Real Rsc (unit= "")"Scavenging ratio";
Real nsc (unit= "%")"Scavenging efficiency";
Real ntr (unit= "%")"Trapping efficiency";


// Equation Section

equation
da =(p *10^5) /(R*T); 
Vs =(( pi)*(d ^2) *l )/4; 
V=(r/(r -1) )*Vs; 
m=da*V; 
m1=m*N; 
Rsc =mf/m1; 
nsc =((1 -e^(-Rsc))*100);
ntr =(( nsc /100) / Rsc )*100; 

end Ex11_2;
