//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth //Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-16: Engine Testing and Performance
//Example: 16.5 Page 
//======================================================

model Ex16_5
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real d (unit= "m")=0.15; 
parameter Real L (unit= "m")=0.16;
parameter Real N (unit= "rpm")=500;
parameter Real mf (unit= "kg/min")=0.0475;
parameter Real CV (unit= "kJ/kg")=42000;
parameter Real w (unit= "N")=400;
parameter Real c (unit= "m")=2.2;
parameter Real l (unit= "mm")=50;
parameter Real ap (unit= "mm^2")=475;
parameter Real an (unit= "mm^2")=25;
parameter Real s (unit= "bar/mm")=0.8333;


final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";


// Variable Section
Real r (unit= "m")"Arm length";
Real T (unit= "Nm")"Torque";
Real bp (unit= "kW")"Brake power";
Real M (unit= "mm")"Mean height of indicative diagram";
Real imep (unit= "bar")"Indicated mean effective pressure";
Real ip (unit= "kW")"Indicated power";
Real nm (unit= "%")"Mechanical efficiency";
Real nb (unit= "%")"Brake thermal efficiency";
Real ni (unit= "%")"Indicated thermal efficiency";
Real bsfc (unit= "kg/kWh")"Brake specific fuel consumption";


// Equation Section

equation
r=c /(2* pi); 
T=w*r; 
bp =(2* pi*N*T) /(60*1000) ; 
M=(ap -an)/l; 
imep =M*s; 
ip =( imep *10^5* L*( pi /4) *d ^2*( N /(2*60) )*(1/1000) ); 
nm =( bp/ip) *100; 
nb =(( bp *60) /( mf*CV) )*100; 
ni =(( nb /100) /( nm /100) )*100; 
bsfc =( mf *60) /bp; 

end Ex16_5;
