//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth //Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-16: Engine Testing and Performance
//Example: 16.6 Page 
//======================================================

model Ex16_6
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real n (unit= "")=8; 
parameter Real d (unit= "m")=0.08; 
parameter Real L (unit= "m")=0.1; 
parameter Real N (unit= "rpm")=4500; 
parameter Real dy (unit= "m")=0.55; 
parameter Real w (unit= "kg")=40; 
parameter Real c (unit= "cc")=100; 
parameter Real t (unit= "s")=9.5; 
parameter Real CV (unit= "kJ/kg")=44000; 
parameter Real p (unit= "bar")=1; 
parameter Real T (unit= "K")=300; 
parameter Real ma (unit= "kg/min")=6; 
parameter Real g (unit= "")=0.7; 
parameter Real gg (unit= "")=1.4; 
parameter Real Vc (unit= "cc")=65; 
parameter Real R (unit= "J/kgK")=287;


final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";


// Variable Section
Real bp (unit= "kW")"Brake power";
Real bmep (unit= "bar")"Brake mean effective pressure";
Real mf (unit= "kg/h")"Mass flow rate of fuel";
Real bsfc (unit= "kg/kWh")"Brake specific fuel consumption";
Real bsac (unit= "kg/kWh")"Brake specific air consumption";
Real a (unit= "")"Air fuel ratio";
Real nb (unit= "%")"Brake thermal efficiency";
Real Va (unit= "m^3/min")"Volume flow rate of air at intake conditions";
Real Vs (unit= "m^3/min")"Swept volume per minute";
Real nv (unit= "%")"Volumetric efficiency";
Real Vs1 (unit= "cc")"Swept volume per cylinder";
Real cr (unit= "")"Compression ratio";
Real na (unit= "%")"Air standard efficiency";
Real re (unit= "%")"Relative efficiency";



// Equation Section

equation
bp =(2* pi*N*dy*w *9.81) /(60*1000) ; 
bmep =(( bp *1000*60) /(L*( pi /4) *d ^2*( N /2) *n) )/10^5; 
mf =(c*g *3600) /(t *1000) ;
bsfc =( mf/bp);
bsac =( ma *60) /bp; 
a= bsac / bsfc ;
nb =(( bp *3600) /( mf*CV)) *100; 
Va =( ma*R*T)/(p *10^5) ;
Vs =( pi /4) *d ^2*L*(N /2) *n;
nv =( Va/Vs) *100; 
Vs1 =(( pi /4)*d ^2* L )*10^6; 
cr =( Vs1+Vc)/Vc; 
na =(1 -(1/ cr)^(gg -1) )*100; 
re =(( nb)/( na) )*100; 

end Ex16_6;
