//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth //Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-16: Engine Testing and Performance
//Example: 16.9 Page 
//======================================================

model Ex16_9
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real n (unit= "")=6; 
parameter Real bp (unit= "kW")=130; 
parameter Real N (unit= "rpm")=1800; 
parameter Real CV (unit= "kJ/kg")=42000; 
parameter Real C (unit= "%")=86; 
parameter Real H (unit= "%")=13; 
parameter Real NC (unit= "%")=1; 
parameter Real na (unit= "%")=85; 
parameter Real ni (unit= "%")=38; 
parameter Real nm (unit= "%")=80; 
parameter Real ac (unit= "%")=110; 
parameter Real sb (unit= "")=1.2; 
parameter Real da (unit= "kg/m^3")=1.3; 


final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";


// Variable Section
Real saf (unit= "")"Stoichiometric air fuel ratio";
Real aaf (unit= "")"Actual air fuel ratio";
Real Ma (unit= "kg/kmol")"Molecular ight of air";
Real a (unit= "")"Carbon balance";
Real b (unit= "")"Hydrogen balance";
Real x (unit= "kmol/kg of fuel")"No. of kmol of air per kg";
Real c (unit= "")"Oxygen balance";
Real d1 (unit= "")"Nitrogen balance";
Real ip (unit= "kW")"Indicated power";
Real mf (unit= "kg/s")"Mass flow rate of fuel";
Real ma (unit= "kg/s")"Mass flow rate of air";
Real Va (unit= "m^3/s")"Actual volume flow rate";
Real Vs (unit= "m^3/s")"Swept volume per second";
Real d (unit= "mm")"Diameter of bore";
Real L (unit= "mm")"Length of stroke";
Real T (unit= "kmol")"Total composition";
Real CO2 (unit= "%")"Volume of CO2";
Real O2 (unit= "%")"Volume of O2";
Real N2 (unit= "%")"Volume of N2";


// Equation Section

equation
saf =((( C /100) *(32/12) ) +(( H /100) *(8/1) )) *(1/0.23) ; 
aaf = saf *(1+1.1) ; 
Ma =(0.23*32) +(0.77*28) ; 
a=(C /100) /12; 
b=(H /100) /2;
x= aaf /Ma; 
c =(0.21* x)-a -(b/2);
d1 =0.79* x; //
ip=bp /( nm /100) ; 
mf=ip /(( ni /100) *CV ); 
ma=mf* aaf ; 
Va=ma/da; 
Vs=Va /( na /100) ; 
d =(( Vs *(4/ pi) *(1/1.2) *((2*60) /N) *(1/ n) )^(1/3) )*1000;
L =1.2* d; 
T=a+c+d1; 
CO2 =(a/T) *100;
O2 =(c/T) *100; 
N2 =( d1/T) *100; 

end Ex16_9;
