//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth 
//Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-02: Air Standard Cycles and their Analysis
//Example: 02.10 Page 
//======================================================

model Ex2_10
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real p1 (unit= "bar")=1; //Inlet pressure
parameter Real T1 (unit= "K")=300; //Temperature
parameter Real p2 (unit= "bar")=4; //Pressure at point 2
parameter Real Cv (unit= "kJ/kgK")=0.573; //Specific heat at constant volume for gas
parameter Real Cp (unit= "kJ/kgK")=0.761; //Specific heat at constant pressure for gas
parameter Real p3 (unit= "bar")=16; //Maximum pressure


final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of 
gravity on earth";


// Variable Section
Real g (unit= "")"";//Adiabatic index
Real T2 (unit= "K")"Temperature";
Real T3 (unit= "K")"Temperature";
Real T4 (unit= "K")"Temperature";
Real Q1 (unit= "kJ/kg")"Heat supplied";
Real Q2 (unit= "kJ/kg")"Heat rejected";
Real W (unit= "kJ/kg")"Work done";
Real n (unit= "")"Efficiency of cycle";
Real r (unit= "")"Compression ratio";
Real R (unit= "kJ/kgK")"Universal gasconstant";
Real Vs (unit= "m^3/kg")"Swept volume";
Real pm (unit= "bar")"Mean effective pressure";


// Equation Section

equation

g=( Cp/Cv) ;
T2 =( T1 *( p2/p1)^((g -1) /g)); 
T3 =( p3/p2)*T2 ;
T4=T3 *( p1/p3)^((g -1) /g) ;
Q1=Cv *(T3 -T2) ;
Q2=Cp *(T4 -T1) ;
W=Q1 -Q2 ;
n=(W/Q1) *100 ;
r=( p2/p1) ^(1/ g) ;
R=(Cp -Cv) ;
Vs =(R *1000* T1 *(r -1) )/( p1 *10^5* r);
pm =(W/( Vs *100) ) ;

end Ex2_10;
