//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth 
//Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-02: Air Standard Cycles and their Analysis
//Example: 02.2 Page 
//======================================================

model Ex2_2
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real CV (unit= "kJ/kg")=42000; //Caloric value of fuel
parameter Real pa (unit= "")=5; //% of compression
parameter Real Pa (unit= "")=1.2; // Pressure in cylinder at 5% compression
parameter Real pb (unit= "")=75; // % of compression
parameter Real Pb (unit= "")=4.8; // Pressure in cylinder at 75% compression
parameter Real g (unit= "")=1.3; //Polytropic index
parameter Real g1 (unit= "")=1.4; //Isentropic index 
parameter Real n (unit= "")=0.6;  //Air standard efficiancy

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of 
gravity on earth";


// Variable Section
Real V (unit= "")"Ratio of volume";
Real r (unit= "")"Compression ratio";
Real n1 (unit= "")"Relative efficiency";
Real nthj (unit= "")"Indicated thermal efficiency";
Real x (unit= "kg/kW.h")"Specific fuel consumption";

// Equation Section

equation
V=( Pb/Pa) ^(1/1.3); 
r=(V*( pb /100) -(pa /100) ) /((1 -( pa /100) ) -(V*(1 -( pb /100)))) ;
n1 =((1 -(1/ r)^(g1 -1) )) *100 ;
nthj =n*( n1 /100) ;
x =(1/( CV* nthj )) *3600 ;

end Ex2_2;
