//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth 
//Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-02: Air Standard Cycles and their Analysis
//Example: 02.4 Page 
//======================================================

model Ex2_4
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real d (unit= "m")=0.2; //Diameter of cylinder
parameter Real L (unit= "m")=0.3; // Length of the stroke
parameter Real P1 (unit= "bar")=1; //Pressure at beginning of compression
parameter Real T1 (unit= "K")=300; // Temperature at beginning of compression
parameter Real r (unit= "")=16; // Compression ratio
parameter Real V (unit= "")=0.08; // Cut off takes place at endof stroke
parameter Real R (unit= "kJ/kgK")=0.287; // Real gas constant
parameter Real g (unit= "")=1.4; // Isentropic constant
parameter Real Cp (unit= "kJ/kgK")=1.005; // Specific heat at constant pressure
parameter Real Cv (unit= "kJ/kgK")=0.718; // Specific heat at constant volume


final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of 
gravity on earth";


// Variable Section
Real Vs (unit= "m^3")"Swept volume";
Real Vc (unit= "m^3")"Clearance volume";
Real V2 (unit= "m^3")"Volume at point 2";
Real V1 (unit= "m^3")"Volume at point 1";
Real m (unit= "kg")"Amount of mass";
Real P2 (unit= "bar")"Pressure at point 2 ";
Real P3 (unit= "bar")"Pressure at point 3";
Real T2 (unit= "K")"Temperature at point 2";
Real V3 (unit= "m^3")"Volume at point 3";
Real C (unit= "")"Cut off ratio";
Real T3 (unit= "K")"Temperature at point 3";
Real P4 (unit= "bar")"Pressure at point 4";
Real T4 (unit= "K")"Temperature at point 4";
Real V4 (unit= "m^3")"olume at point 4";
Real Q1 (unit= "kJ")"Heat supplied";
Real Q2 (unit= "kJ")"Heat rejected";
Real W (unit= "kJ")"Work done";
Real na (unit= "")"Air standard efficiency";
Real Pm (unit= "bar")"Mean effective pressure";


// Equation Section

equation
Vs =( pi /4) *d ^2*L; 
Vc=Vs /(r -1) ; 
V2=Vc; 
V1=Vs+Vc;
m=( P1 *10^5* V1)/(R*T1); 
P2=P1 *(r^g); 
P3=P2; 
T2=T1*r^(g -1) ; 
V3 =(V*Vs)+V2;
C=V3/V2; 
T3=C*T2; 
P4=P3 *(C/r)^g; 
T4=T3 *(C/r)^(g -1); 
V4=V1; 
Q1 =(m*Cp *(T3-T2))/1000; 
Q2 =(m*Cv *(T4 -T1) )/1000; 
W=Q1 -Q2 ; 
na =(W/Q1) *100; 
Pm =(W *1000)/( Vs*10^5); 

end Ex2_4;
