//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth 
//Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-02: Air Standard Cycles and their Analysis
//Example: 02.8 Page 
//======================================================

model Ex2_8
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real rc (unit= "")=15; //Compression ratio
parameter Real p1 (unit= "bar")=1; //Pressure at which compression begins
parameter Real T1 (unit= "K")=300; //Temperature
parameter Real pm (unit= "bar")=60; //Maximum pressure
parameter Real h (unit= "")=2;  // Heat transferred to air at constant volume is twice that at constant pressure
parameter Real g (unit= "")=1.4; // Isentropic index
parameter Real Cv (unit= "kJ/kgK")=0.718; //Specific heat at contant volume of air
parameter Real Cp (unit= "kJ/kgK")=1.005;//Specific heat at contant pressure of air 
parameter Real R (unit= "kJ/kgK")=0.287; // Real gas constant


final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of 
gravity on earth";


// Variable Section
Real T2 (unit= "K")"Temperature";
Real p2 (unit= "bar")"Pressure";
Real T3 (unit= "K")"Temperature";
Real T4 (unit= "K")"Temperature";
Real b (unit= "")"Cutoff ratio";
Real T5 (unit= "K")"Temperature";
Real p5 (unit= "bar")"Pressure";
Real Q1 (unit= "kJ/kg")"Heat supplied per unit mass";
Real Q2 (unit= "kJ/kg")"Heat rejected per unit mass";
Real W (unit= "kJ/kg")"Work done";
Real n (unit= "")"Air standard efficiancy";
Real Vs (unit= "m^3/kg")"Swept volume";
Real pmean (unit= "bar")"Mean effective pressure";

// Equation Section

equation
T2 =( T1*rc ^(g -1)); 
p2 =( p1*rc^g) ;
T3 =( T2 *( pm/p2));
T4 =( Cv *(T3 -T2)) /(2* Cp)+T3 ;
b=( T4/T3) ;
T5 =( T4 *(b/rc)^(g -1) );
p5 =( p1 *( T5/T1)) ;
Q1 =( Cv *(T3 -T2))+( Cp *(T4 -T3)); 
Q2=Cv *(T5 -T1);
W=(Q1 -Q2) ;
n=(W/Q1) *100;
Vs =((1* R *1000* T1)/( p1 *10^5) ) *(1 -1/ rc) ;
pmean =(( W *1000) /(Vs*10^5) ) ;

end Ex2_8;
