//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth //Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-03: Reactive Systems
//Example: 03.13 Page 
//======================================================

model Ex3_13
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real cv (unit= "kJ/kg")=44000; 
parameter Real C (unit= "%")=84; 
parameter Real H (unit= "")=16; 
parameter Real t (unit= "")=25; 
parameter Real hfg (unit= "")=2442; 
parameter Real c (unit= "")=12; 
parameter Real h (unit= "")=2; 
parameter Real co2 (unit= "")=44; 
parameter Real h2o (unit= "")=18; 
parameter Real o2 (unit= "")=32; 
parameter Real R (unit= "")=8.314; 


final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";


// Variable Section
Real CO2 (unit= "kg")"Amount of CO2 present per kg of fuel";
Real H2O (unit= "kg")"Amount of H2O present per kg of fuel";
Real cvd (unit= "kJ/kg")"Difference in higher and lower calorific value";
Real HHV (unit= "kJ/kg")"Higher calorific value of liquid fuel";
Real np (unit= "kmol/kg")"No. of moles of product";
Real nr (unit= "kmol/kg")"No. of moles of reactant";
Real n (unit= "moles")"Difference in number of moles";
Real HHVv (unit= "kJ/kg")"Higher calorific value at constant volume";
Real LHVv (unit= "kJ/kg")"Lower calorific value at constant volume";


// Equation Section

equation
CO2 =(0.84*( co2 /c)); 
H2O =(0.16*( h2o /h)); 
cvd = H2O *hfg; 
HHV =cv+cvd;
np =3.08/ co2 ; 
nr =3.52/ o2; 
n=np -nr; 
HHVv =HHV +(n*R*(t +273) ); 
LHVv =cv +(n*R*(t +273) ); 

end Ex3_13;
