//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth //Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-03: Reactive Systems
//Example: 03.3 Page 
//======================================================

model Ex3_3
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real C (unit= "kg")=0.86; //Amount of carbon content in 1kg of fuel by weight  
parameter Real H (unit= "")=0.05; //Amount of hydrogen content in 1kg of fuel by weight
parameter Real O (unit= "")=0.02; //Amount of oxygen content in 1kg of fuel by weight
parameter Real S (unit= "")=0.005; //Amount of sulphur content in 1kg of fuel by weight
parameter Real N (unit= "")=0.065;//Amount of nitrogen content in 1kg of fuel by weight 
parameter Real E (unit= "%")=25; //Amount of excess air supplied 
parameter Real o (unit= "")=32; //Molecular weight of oxygen
parameter Real co (unit= "")=44; //Molecular weight of carbodioxide
parameter Real c (unit= "")=12;//Molecular weight of  carbon
parameter Real s (unit= "")=32; //Molecular weight of sulphur 
parameter Real so (unit= "")=64; //Molecular weight of sulphur dioxide
parameter Real n (unit= "")=28;//Molecular weight of  nitrogen


final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";


// Variable Section
Real o1 (unit= "kg")"Amount of oxygen required for 0.86kg of carbon";
Real coa (unit= "kg")"Amount of carbondioxide required for 0.86kg of carbon";
Real o2 (unit= "kg")"Amount of oxygen required for 0.05kg of hydrogen";
Real h2 (unit= "kg")"Amount of water required for 0.05kg of hydrogen";
Real o3 (unit= "kg")"Amount of oxygen required for 0.005kg of sulphur";
Real s1 (unit= "kg")"Amount of sulphur dioxide produced for 0.005kg of sulphur";
Real To (unit= "kg")"Total oxygen required for the complete combustion of fuel";
Real Tt (unit= "kg")"Amount of oxygen required per kg of fuel for complete combustion theortically";
Real As (unit= "")"Stoichiometric air/fuel ratio";
Real as (unit= "kg")"Actual quantity of air supplied per kg of fuel";
Real o2a (unit= "kg")"Oxygen in the excess air";
Real n2a (unit= "kg")"Nitrogen in the excess air";
Real n2e (unit= "kg")"Total nitrogen in exhaust";
Real Tw (unit= "kg")"Total weight";
Real pco (unit= "%")"% composition of carbondioxide";
Real pn (unit= "%")"% composition of nitrogen";
Real po (unit= "%")"% composition of oxygen";
Real mco (unit= "moles")"Moles of carbondioxide";
Real mn (unit= "moles")"Moles of nitrogen";
Real mo (unit= "moles")"Moles of oxygen";
Real Tm (unit= "moles")"Total moles";
Real vco (unit= "%")"Volumetric analysis of carbondioxide";
Real vn (unit= "%")"Volumetric analysis of nitrogen";
Real vo (unit= "%")"Volumetric analysis of oxygen";


// Equation Section

equation
o1 =(o/c)*C; 
coa =( co/c)*C; 
o2 =(o /4) *H; 
h2 =(36/4) *H; 
o3 =(o/s)*S; 
s1 =( so/s)*S; 
To=o1+o2+o3; 
Tt=To -O;
As =( Tt *100) /23; 
as=As *(1+( E /100) ); 
o2a =0.23*( E /100) *As; 
n2a =0.77*(1+( E /100) )*As; 
n2e = n2a +N; 
Tw=coa+ n2e + o2a; 
pco =( coa /Tw) *100; 
pn =( n2e/Tw) *100; 
po =( o2a/Tw) *100; 
mco =( coa /co); 
mn =( n2e/n); 
mo =( o2a/o); 
Tm=mco+mn+mo; 
vco =( mco /Tm) *100; 
vn =( mn/Tm) *100; 
vo =( mo/Tm) *100; 

end Ex3_3;
