//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth //Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-03: Reactive Systems
//Example: 03.8 Page 
//======================================================

model Ex3_8
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real P (unit= "kW")=600; //Power of an engine
parameter Real t (unit= "deg C")=25;//Temp at which fuel is used  
parameter Real Ta (unit= "%")=150;// Theoritical air used 
parameter Real T1 (unit= "K")=400;// Temperature at which air enters 
parameter Real T2 (unit= "K")=700; //Temperature at which the products of combustion leave
parameter Real Q (unit= "kW")=-150;// Heat loss from the engine 
parameter Real C (unit= "")=12; //Molecular weigth of carbon
parameter Real h (unit= "")=1; //Molecular weight of hydrogen


final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";


// Variable Section
Real hfc (unit= "MJ/kmol")"Enthalpy of compound C*H18 for the given conditions";
Real hfo1 (unit= "MJ/kmol")"Enthalpy of oxygen gas";
Real hfn1 (unit= "MJ/kmol")"Enthalpy of nitrogen gas";
Real HR (unit= "MJ/kmol")"Total enthalpy on the reactants side";
Real hfco (unit= "MJ/kmol")"Enthalpy of carbondioxide for the formation state";
Real hfco1 (unit= "MJ/kmol")"Change in enthalpy of carbondioxide for temp difference";
Real hfh (unit= "MJ/kmol")"Enthalpy of water for formation state";
Real hfh1 (unit= "MJ/kmol")"Change in enthalpy of water for temp difference";
Real hfo2 (unit= "MJ/kmol")"Enthalpy of oxygen gas";
Real hfn2 (unit= "MJ/kmol")"Enthalpy of nitrogen gas";
Real HP (unit= "MJ/kmol")"Total enthalpy on the products side";
Real H (unit= "MJ/kmol")"Total change in enthalpy of reactants and products";
Real nf (unit= "kmol/s")"Fuel rate";
Real M (unit= "")"Molecular weight of fuel";
Real mf (unit= "kg/h")"Fuel consumption";


// Equation Section

equation
//
hfc = -259.28; 
hfo1 =3.029; 
hfn1 =2.971; 
HR =( hfc) +(1.5*12.5* hfo1 ) +(1.5*12.5*3.76* hfn1 ); 
hfco = -393.52; 
hfco1 =17.761; 
hfh = -241.82; 
hfh1 =14.184; 
hfo2 =12.502; 
hfn2 =11.937; 
HP =(8*( hfco + hfco1 )) +(9*( hfh+ hfh1 )) +(6.25* hfo2 )+(70.5* hfn2 ); 
H=HP -HR; 
nf =((Q-P )*3600) /(H *10^3); 
M =(8* C) +(18* h); 
mf=nf*M; 

end Ex3_8;
