//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth //Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-03: Reactive Systems
//Example: 03.9 Page 
//======================================================

model Ex3_9
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real t (unit= "deg C")=25; //Temp at which fuel is used for combustion 
parameter Real p (unit= "bar")=1; //Pressure at which fuel is used
parameter Real T (unit= "K")=400; //Temp of products of combustion
parameter Real R (unit= "")=0.008314;//Universal gas constant 

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";


// Variable Section
Real hfc (unit= "MJ/kmol")"Enthalpy of compound C3H8";
Real HR (unit= "MJ/kmol")"Total enthalpy of reactants";
Real hfco (unit= "MJ/kmol")"Enthalpy ofcarbondioxide";
Real hfco1 (unit= "MJ/kmol")"Change in enthalpy of for given conditions";
Real hfh (unit= "MJ/kmol")"Enthalpy of water";
Real hfh1 (unit= "MJ/kmol")"Change in enthalpy of water";
Real HP (unit= "MJ/kmol")"Total enthalpy of products";
Real Q (unit= "MJ/kmol")"Total change in enthalpy of reactants and products";
Real Q1 (unit= "kJ/mol")"Heat liberated";


// Equation Section

equation

hfc = -103.85; 
HR =(1*( hfc -(R*(t +273) )) )+(5*( - R*(t +273) )); 
hfco = -393.52; 
hfco1 =4.008; 
hfh = -241.82; 
hfh1 =3.452; 
HP =(3*( hfco +hfco1 -(R*T)) )+(4*( hfh +hfh1 -(R*T))); 
Q=HP -HR; 
Q1=-Q; 

end Ex3_9;
