//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth //Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-4: Fuel Air Cycles and Their Analysis
//Example: 4.14 Page 
//======================================================

model Ex4_14
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real r (unit= "")=8; 
parameter Real T1 (unit= "K")=350; 
parameter Real p (unit= "bar")=1; 
parameter Real f (unit= "")=0.08; 
parameter Real cv (unit= "kJ/kg")=44000; 


final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";


// Variable Section
Real W1 (unit= "J/kgK")"Isentropic compression functions for corrosponding temp T1";
Real W2 (unit= "J/kgK")"Isentropic compression function";
Real T2 (unit= "K")"Temp corrosponding to isentropic  compression function ";
Real V1 (unit= "m^3/kg")"Initial volume";
Real p2 (unit= "atm")"Pressure at point 2";
Real V2 (unit= "m^3/kg")"Volume atpoint 2";
Real us2 (unit= "K")"Internal energy corrosponding to temp T2";
Real us1 (unit= "K")"Internal energy corrosponding to temp T1";
Real Wc (unit= "kJ/kg")"Adiabatic compression work";
Real ufu (unit= "kJ/kg")"Internal energy of formation";
Real u3 (unit= "kJ/kg")"Internal energy at point 3";
Real V3 (unit= "m^3/kg")"Volume at point 3";
Real T3 (unit= "K")"Temp at point 3 corrosponding to u3.V3 on burned gas chart";
Real p3 (unit= "kN/m^2")"Pressure at point 3";
Real s3 (unit= "kJ/kg")"Entrophy at point 3";
Real s4 (unit= "kJ/kg")"Entrophy atpoint 4";
Real V4 (unit= "m^3/kg")"Volume at point 4";
Real u4 (unit= "kJ/kg")"Internal energy at point 4 corrosponding to V4.s4 on burned gas chart";
Real p4 (unit= "kN/m^2")"Pressure at point 4";
Real T4 (unit= "K")"Temp at point 4";
Real We (unit= "kJ/kg")"Expansion work";
Real Wn (unit= "kJ/kg")"Net work output";
Real nth (unit= "%")"Indicated thermal efficiency";
Real imep (unit= "bar")"Indicated mean effective pressure";
Real nv (unit= "%")"Volumetric efficiency";


// Equation Section

equation
W1 =150; 
W2=W1 -(292*log(1/r));
T2 =682; 
V1 =(292* T1)/(p *10^5) ; 
p2=p*( T2/T1)*r; 
V2=V1/r; 
us2 =350;
us1 =40; 
Wc=us2 - us1 ; 
ufu = -118.5 -(2963* f); 
u3=us2+ ufu ; 
V3=V2; 
T3 =2825; 
p3 =7100; 
s3 =9.33; 
s4=s3; 
V4=V1; 
u4 = -1540; 
p4 =570; 
T4 =1840; 
We=u3 -u4; 
Wn=We -Wc; 
nth =(( Wn)/((1 -f) *0.0662* cv) )*100; 
imep =(( Wn *1000) /(V1 -V2)) /10^5; 
nv =(((1 - f) *287*298) /(1.013*10^5*(1 -0.125) ) )*100; 


end Ex4_14;
