//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth 
//Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-4: Fuel Air Cycles and Their Analysis
//Example: 4.2 Page 
//======================================================

model Ex4_2
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real r (unit= "")=18;
parameter Real l (unit= "%")=6;
parameter Real sc (unit= "%")=2;
parameter Real cv (unit= "kJ/kgK")=0.717;
parameter Real R (unit= "kJ/kgK")=0.287;
 

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of 
gravity on earth";


// Variable Section
Real Vs (unit= "")"Ratio of swept volume and volume 2";
Real B (unit= "")"Cut off ratio";
Real cp (unit= "kJ/kgK")"Specific heat at constant pressure";
Real R1 (unit= "")"Ratio of specific heats";
Real n (unit= "")"Efficiency of diesal cycle";
Real dn (unit= "%")"Efficiency decrease";

//Round off error in book answer

// Equation Section

equation
Vs =(r -1) ; 
B =(( l /100) *Vs)+1; 
cp=cv+R; 
R1=cp/cv; 
n =1 -(((((1/ r)^(R1 -1) )*( B^R1 -1) )/( R1 *(B -1))) );
dn =(((1 - n)/n)*(R1 -1) *(((log(r))-(((B^R1)*log(B))/(B^R1-1))+(1/B)))*(sc/100))*100;

end Ex4_2;
