//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth 
//Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-4: Fuel Air Cycles and Their Analysis
//Example: 4.7 Page 
//======================================================

model Ex4_7
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real f (unit= "")=0.03; 
parameter Real eq (unit= "")=1.2; 

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of 
gravity on earth";


// Variable Section
Real F (unit= "")"Fuel/air ratio for corrosponding equivalent ratio";
Real T (unit= "kg")"Total mass";
Real fa (unit= "kg")"Fresh air";
Real ff (unit= "kg")"Fresh fuel";
Real ra (unit= "kg")"Air in residual";
Real rf (unit= "kg")"Fuel in residual";

// Equation Section
equation
F =0.0795; 
T =1+ F; 
fa =1-f; 
ff=F*( fa); 
ra=f; 
rf=ra*F; 

end Ex4_7;
