//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth //Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-9: Carburettors and Fuel Injection in SI Engines
//Example: 9.5 Page 
//======================================================

model Ex9_5
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real mf (unit= "kg/s")=0.00166666666666666666666666666667; 
parameter Real df (unit= "kg/m^3")=750; 
parameter Real Z (unit= "m")=0.003; 
parameter Real p (unit= "bar")=1.013; 
parameter Real T (unit= "K")=294; 
parameter Real dj (unit= "m")=0.0012; 
parameter Real Cdf (unit= "")=0.65; 
parameter Real Cda (unit= "")=0.8; 
parameter Real A (unit= "")=15.3; 
parameter Real R (unit= "J/kgK")=287; 
parameter Real dh (unit= "kg/m^2")=1000; 

final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";


// Variable Section
Real da (unit= "kg/m^3")"Density of air";
Real Ca2 (unit= "m/s")"Critical air velocity at throat";
Real Aj (unit= "m^2")"Area of jet";
Real P (unit= "bar")"Depression at throat";
Real h (unit= "meter of water")"Metre of water";
Real h1 (unit= "mm of water")"mm of water";
Real ma (unit= "kg/s")"Mass flow rate of air";
Real A2 (unit= "cm^2")"Area of throat";
Real d2 (unit= "mm")"Effective throat diameter";


// Equation Section

equation
da =(p *10^5) /(R*T); 
Ca2 = Cda *((2* g_n*Z*df)/da) ^(1/2) ; 
Aj =( pi /4) *dj ^2; 
P =(( mf ^2/( Cdf ^2* Aj ^2*2* df))+(g_n*Z*df) )/10^5; 
h=(P *10^5) /( dh*g_n); 
h1 =(P *10^5) /g_n; 
ma=mf*A; 
A2 =( ma /(( Cda *(2* da *(P *10^5) ) ^(1/2) )) )*10^4; 
d2 =(( A2 *4/ pi) ^(1/2) )*10; 

end Ex9_5;
