//H. N. Gupta, Fundamentals Of Internal Combustion Engines,Fourth //Edition, Prentice Hall of India Pvt Ltd New Delhi, 2006

//Chapter-9: Carburettors and Fuel Injection in SI Engines
//Example: 9.8 Page 
//======================================================

model Ex9_8
extends Modelica.Math;
import SI = Modelica.SIunits;

// Parameter Section
parameter Real A (unit= "")=14.5; 
parameter Real p2 (unit= "bar")=0.825; 
parameter Real p1 (unit= "bar")=1.013; 
parameter Real pd (unit= "mm of Hg")=37.5; 
parameter Real ma (unit= "kg/h")=260; 


final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
final constant SI.Acceleration g_n=9.80665 "Standard acceleration of gravity on earth";


// Variable Section
Real pa (unit= "bar")"Without air cleaner the depression at throat";
Real p21 (unit= "bar")"Throat pressure hen air cleaner is fitted";
Real pf (unit= "bar")"Pressure of fuel without air cleaner";
Real pf1 (unit= "bar")"Pressure of fuel ith air cleaner";
Real Af (unit= "")"Air fuel ratio ith air cleaner";


// Equation Section

equation
pa=p1 -p2; 
p21 =p1 -( pd /750) -pa; 
pf=pa; 
pf1 =p1 -p21; 
Af=A*( pf/ pf1 ) ^(1/2) ; 

end Ex9_8;
