model Ex2_24
parameter Real L(unit="m")=1"Length of pipe";
parameter Real thp(unit="mm")=2"Thickness of pipe";
parameter Real thi(unit="mm")=10"Thickness of insulation";
parameter Real T1(unit = "K")=373"steam temperature";
parameter Real T2(unit = "K")=298"surrounding temperature";
parameter Real id(unit="mm")=30"Inner Dia of pipe";
parameter Real k1(unit = "W/m.K")=17.44"k for pipe metal";
parameter Real k2(unit = "W/m.K")=0.58"k for insulation";
parameter Real hi(unit = "W/(m^2.K)")=11.63"Inside heat transfer coefficient ";
parameter Real ho(unit = "W/(m^2.K)")=11.63"Outside heat transfer coefficient ";

Real r1(unit="mm")"Inner Radius of pipe";
Real r2(unit="mm")"outer Radius of pipe";
Real r3(unit="mm")"Radius of insulation";
Real R1(unit="m")"Inner Radius of pipe";
Real R2(unit="m")"outer Radius of pipe";
Real R3(unit="m")"Radius of insulation";
Real Q(unit="W")"rate of heat loss";
equation
r1=id/2;
r2=r1+thp;
r3=r2+thi;
//In S.I units
R1=r1/1000; 
R2=r2/1000;
R3=r3/1000;
//Solution
Q=(2*22/7*L*(T1-T2))/(1/(R1*hi)+(log(R2/R1))/k1+((log(R3/R2))/k2)+(1/(0.02*ho)));
end Ex2_24;
